﻿using System.Collections.Generic;
using System.Data;


public class ImagingDataRepository
{
    private const string CONNECT_STRING_NAME = "RegistryConnectionString";

    internal static IEnumerable<string> LoadReferenceValuesDescription(string storedProcedure, string selectValueMessage = null)
    {
        IList<string> result = new List<string>();
        if (!string.IsNullOrEmpty(selectValueMessage))
            result.Add(selectValueMessage);

        using (var imageFragmentSizeTable = SqlProvider.ExecuteSPDataTable(
            CONNECT_STRING_NAME,
            storedProcedure))
        {
            if (imageFragmentSizeTable != null
                && imageFragmentSizeTable.Rows != null
                && imageFragmentSizeTable.Rows.Count > 0)
            {
                foreach (DataRow row in imageFragmentSizeTable.Rows)
                    result.Add(row.Field<string>("DESCRIPTION_TEXT"));
            }
        }

        return result;
    }

    internal static IEnumerable<string> LoadReferenceValuesNameWithDescription(string storedProcedure)
    {
        const string DISPLAY_FORMAT = "{0} ({1})";

        IList<string> result = new List<string>();

        using (var imageFragmentSizeTable = SqlProvider.ExecuteSPDataTable(
            CONNECT_STRING_NAME,
            storedProcedure))
        {
            if (imageFragmentSizeTable != null
                && imageFragmentSizeTable.Rows != null
                && imageFragmentSizeTable.Rows.Count > 0)
            {
                foreach (DataRow row in imageFragmentSizeTable.Rows)
                    result.Add(
                        string.Format(
                            DISPLAY_FORMAT,
                            row.Field<string>("NAME"),
                            row.Field<string>("DESCRIPTION_TEXT")));
            }
        }

        return result;
    }
}